uniform vec2 u_lightDirection;
//Size of the oclussion map
uniform vec2 u_occlusionMapUVSize;
uniform vec2 u_shadowMapUVSize;
uniform vec2 u_PixelUVSize;
uniform float u_lightIntensity;
//This should be max when the emissor is vertical
uniform float u_shadowStr;
uniform  vec2 u_gridSize;

//actual tex coord (taking in account the POT factor)
varying vec2 v_texCoord;
varying vec2 v_gridTexCoord;


void main(void) {

    //clamped grid coords
    //vec2 cCoords = floor(v_gridTexCoord * u_gridSize ) / u_gridSize * u_occlusionMapUVSize;
    
    vec2 cCoords = v_gridTexCoord * u_occlusionMapUVSize;
    
    //Obtain the shadow map sample point
    //CC_TEXTURE1 lightmap
    //CC_TEXTURE2 original texture
    //CC_TEXTURE0 bulbLightMap ->no shadows here
    
    float light = texture2D(CC_Texture1,  cCoords).a;
    vec4 bulbLight = texture2D(CC_Texture0, cCoords);
    vec4 samp = texture2D(CC_Texture2, v_texCoord);
    
    vec4 finalColor = vec4(0.0);
    finalColor = samp  -  (1.0 - max(light,4.0*bulbLight.r) ) * u_lightIntensity;
    gl_FragColor = finalColor ;
    
    
 
}
